/** 
 * Demonstration of encapsulation by 
 * creating and manipulating objects 
 * of type Account.
 */

public class AccountMain {
	
	public static void main(String[] args) {
		
		double i = Account.getInterest();
		System.out.println("The common interest is " + i);
		
		// Create objects (call constructor)
		Account a1 = new Account("Anders", 50000);
		Account a2 = new Account("Anna", 12);
		
		System.out.println(a1.toString());
		System.out.println(a2.toString());
		
		// The common interest (static) is changed
		// by calling a static method
		Account.setInterest(0.75);
		i = Account.getInterest();
		System.out.println("The common interest is now " + i);
		
		// Add the interest to each account 
		// (non-static method).
		a1.addInterest();
		a2.addInterest();
		
		System.out.println(a1.toString());
		System.out.println(a2.toString());
	}
}